/*
 * Decompiled with CFR 0.152.
 */
package me.juancarloscp52.bedrockify.client;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Optional;
import me.juancarloscp52.bedrockify.Bedrockify;
import me.juancarloscp52.bedrockify.client.BedrockifyClientSettings;
import me.juancarloscp52.bedrockify.client.features.bedrockShading.BedrockBlockShading;
import me.juancarloscp52.bedrockify.client.features.bedrockShading.BedrockSunGlareShading;
import me.juancarloscp52.bedrockify.client.features.fishingBobber.FishingBobber3DModel;
import me.juancarloscp52.bedrockify.client.features.heldItemTooltips.HeldItemTooltips;
import me.juancarloscp52.bedrockify.client.features.hudOpacity.HudOpacity;
import me.juancarloscp52.bedrockify.client.features.reacharoundPlacement.ReachAroundPlacement;
import me.juancarloscp52.bedrockify.client.features.sheepColors.SheepSkinResource;
import me.juancarloscp52.bedrockify.client.features.worldColorNoise.WorldColorNoiseSampler;
import me.juancarloscp52.bedrockify.client.gui.Overlay;
import me.juancarloscp52.bedrockify.client.gui.SettingsGUI;
import me.juancarloscp52.bedrockify.common.block.cauldron.BedrockCauldronBehavior;
import me.juancarloscp52.bedrockify.common.block.entity.WaterCauldronBlockEntity;
import me.juancarloscp52.bedrockify.common.features.cauldron.BedrockCauldronBlocks;
import me.juancarloscp52.bedrockify.common.payloads.CauldronParticlePayload;
import me.juancarloscp52.bedrockify.common.payloads.EatParticlePayload;
import me.juancarloscp52.bedrockify.mixin.featureManager.MixinFeatureManager;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_2248;
import net.minecraft.class_2596;
import net.minecraft.class_2848;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3675;
import net.minecraft.class_5601;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BedrockifyClient
implements ClientModInitializer {
    private static BedrockifyClient instance;
    public static final Logger LOGGER;
    public ReachAroundPlacement reachAroundPlacement;
    public Overlay overlay;
    public HeldItemTooltips heldItemTooltips;
    public SettingsGUI settingsGUI;
    public WorldColorNoiseSampler worldColorNoiseSampler;
    public BedrockBlockShading bedrockBlockShading;
    public BedrockSunGlareShading bedrockSunGlareShading;
    public HudOpacity hudOpacity;
    public long deltaTime = 0L;
    private int timeFlying = 0;
    private static class_304 keyBinding;
    public BedrockifyClientSettings settings;

    public static BedrockifyClient getInstance() {
        return instance;
    }

    public void onInitializeClient() {
        instance = this;
        this.loadSettings();
        LOGGER.info("Initializing BedrockIfy Client.");
        this.overlay = new Overlay(class_310.method_1551());
        this.reachAroundPlacement = new ReachAroundPlacement(class_310.method_1551());
        this.heldItemTooltips = new HeldItemTooltips();
        this.settingsGUI = new SettingsGUI();
        this.worldColorNoiseSampler = new WorldColorNoiseSampler();
        this.bedrockBlockShading = new BedrockBlockShading();
        this.bedrockSunGlareShading = new BedrockSunGlareShading();
        this.hudOpacity = new HudOpacity();
        keyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("bedrockIfy.key.settings", class_3675.class_307.field_1668, 66, "BedrockIfy"));
        EntityModelLayerRegistry.registerModelLayer((class_5601)FishingBobber3DModel.MODEL_LAYER, FishingBobber3DModel::generateModel);
        if (MixinFeatureManager.features.get("common.features.cauldron").booleanValue()) {
            ColorProviderRegistry.BLOCK.register((state, world, pos, tintIndex) -> {
                if (world == null || pos == null) {
                    return -1;
                }
                Optional entity = world.method_35230(pos, BedrockCauldronBlocks.WATER_CAULDRON_ENTITY);
                return entity.map(WaterCauldronBlockEntity::getTintColor).orElse(-1);
            }, (Object[])new class_2248[]{BedrockCauldronBlocks.POTION_CAULDRON, BedrockCauldronBlocks.COLORED_WATER_CAULDRON});
            ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> BedrockCauldronBehavior.registerBehavior());
        }
        if (!FabricLoader.getInstance().isModLoaded("optifabric")) {
            ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SheepSkinResource());
        }
        ClientPlayNetworking.registerGlobalReceiver(Bedrockify.EAT_PARTICLE_PAYLOAD.method_56479(), (ClientPlayNetworking.PlayPayloadHandler)new EatParticlePayload.EatParticleHandler());
        ClientPlayNetworking.registerGlobalReceiver(Bedrockify.CAULDRON_PARTICLE_PAYLOAD.method_56479(), (ClientPlayNetworking.PlayPayloadHandler)new CauldronParticlePayload.CauldronParticleHandler());
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> BedrockifyClient.getInstance().overlay.renderOverlay(drawContext));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (keyBinding.method_1436()) {
                client.method_1507(this.settingsGUI.getConfigScreen(client.field_1755));
            }
            this.hudOpacity.tick();
            this.bedrockSunGlareShading.tick(client.method_60646().method_60637(true));
            if (this.settings.disableFlyingMomentum && null != client.field_1724 && client.field_1724.method_31549().field_7479) {
                if (!(client.field_1690.field_1913.method_1434() || client.field_1690.field_1881.method_1434() || client.field_1690.field_1849.method_1434() || client.field_1690.field_1894.method_1434())) {
                    client.field_1724.method_18800(0.0, client.field_1724.method_18798().method_10214(), 0.0);
                }
                if (!client.field_1690.field_1832.method_1434() && !client.field_1690.field_1903.method_1434()) {
                    client.field_1724.method_18800(client.field_1724.method_18798().method_10216(), 0.0, client.field_1724.method_18798().method_10215());
                }
            }
            if (null != client.field_1724 && this.settings.elytraStop && client.field_1724.method_6128() && this.timeFlying > 10 && client.field_1690.field_1903.method_1434()) {
                client.field_1724.method_23670();
                client.field_1724.field_3944.method_52787((class_2596)new class_2848((class_1297)client.field_1724, class_2848.class_2849.field_12982));
            }
            this.timeFlying = null != client.field_1724 && client.field_1724.method_6128() && !client.field_1690.field_1903.method_1434() ? ++this.timeFlying : 0;
        });
        LOGGER.info("Initialized BedrockIfy Client");
    }

    public void loadSettings() {
        File file = new File("./config/bedrockify/bedrockifyClient.json");
        Gson gson = new Gson();
        if (file.exists()) {
            try {
                FileReader fileReader = new FileReader(file);
                this.settings = (BedrockifyClientSettings)gson.fromJson((Reader)fileReader, BedrockifyClientSettings.class);
                fileReader.close();
            }
            catch (IOException e) {
                LOGGER.warn("Could not load bedrockIfy settings: {}", (Object)e.getLocalizedMessage());
            }
        } else {
            this.settings = new BedrockifyClientSettings();
        }
    }

    public void saveSettings() {
        Gson gson = new Gson();
        File file = new File("./config/bedrockify/bedrockifyClient.json");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdir();
        }
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(gson.toJson((Object)this.settings));
            fileWriter.close();
        }
        catch (IOException e) {
            LOGGER.warn("Could not save bedrockIfy settings: {}", (Object)e.getLocalizedMessage());
        }
    }

    static {
        LOGGER = LogManager.getLogger();
    }
}

